<?php
/* --------------------------------------------------------------
   StoredSingleTrackingCode.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeId;

/**
 * Class StoredSingleTrackingCode
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class StoredSingleTrackingCode
{
    /**
     * @var TrackingCodeId
     */
    private $trackingCodeId;
    
    
    /**
     * StoredSingleTrackingCodeEvent constructor.
     *
     * @param TrackingCodeId $trackingCodeId
     */
    private function __construct(TrackingCodeId $trackingCodeId)
    {
        $this->trackingCodeId = $trackingCodeId;
    }
    
    
    /**
     * @param TrackingCodeId $trackingCodeId
     *
     * @return StoredSingleTrackingCode
     */
    public static function create(TrackingCodeId $trackingCodeId): StoredSingleTrackingCode
    {
        return new self($trackingCodeId);
    }
    
    
    /**
     * @return TrackingCodeId
     */
    public function trackingCodeId(): TrackingCodeId
    {
        return $this->trackingCodeId;
    }
    
    
    /**
     * @param TrackingCodeId $trackingCodeId
     */
    public function replaceTrackingCodeId(TrackingCodeId $trackingCodeId): void
    {
        $this->trackingCodeId = $trackingCodeId;
    }
}